'use strict';

/* --------------------------------------------------------------
 image_gallery.js 2016-03-09
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2015 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Widget that opens the gallery modal layer (which is
 * used for the article pictures)
 */
gambio.widgets.module('image_gallery', [gambio.source + '/libs/modal.ext-magnific', gambio.source + '/libs/modal', gambio.source + '/libs/events', gambio.source + '/libs/responsive'], function (data) {

    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        $template = null,
        $body = $('body'),
        layer = null,
        configuration = { // Modal layer configuration
        noTemplate: false,
        preloader: true,
        closeOnOuter: true,
        dialogClass: 'product_images',
        gallery: {
            enabled: true
        }
    },
        defaults = {
        target: '.swiper-slide', // Selector for the click event listener
        template: '#product_image_layer', // Template that is used for the layer
        breakpoint: 40 // Maximum breakpoint for mobile view mode
    },
        options = $.extend(true, {}, defaults, data),
        module = {};

    // ########## EVENT HANDLER ##########

    /**
     * Click event handler that configures the swiper(s)
     * inside the layer and opens it afterwards
     * @param       {object}    e       jQuery event object
     * @private
     */
    var _clickHandler = function _clickHandler(e) {
        e.preventDefault();

        // Only open in desktop mode
        if (jse.libs.theme.responsive.breakpoint().id > options.breakpoint) {
            var $self = $(this),
                $swiper = $template.find('[data-swiper-slider-options]'),
                dataset = $self.data(),
                index = dataset.index || dataset.swiperSlideIndex || 0;

            // Loop that replaces the initial slide of
            // each swiper inside the layer
            $swiper.each(function () {
                $(this).attr('data-swiper-init-slide', index);
            });

            // Opens the modal layer
            layer = jse.libs.theme.modal.custom(configuration);
        }
    };

    /**
     * Handler which closes an opened gallery if the
     * screen width gets under the size of an desktop mode
     * @private
     */
    var _breakpointHandler = function _breakpointHandler() {
        if (jse.libs.theme.responsive.breakpoint().id <= options.breakpoint && layer) {
            layer.close(true);
        }
    };

    /**
     * Event handler to append / remove slides from the
     * gallery layer swipers
     * @param       {object}        e           jQuery event object
     * @param       {object}        d           JSON data of the images
     * @private
     */
    var _addSlides = function _addSlides(e, d) {

        // Loops through all swipers inside the layer
        $template.find('.swiper-container template').each(function () {
            var $tpl = $(this),
                $slideContainer = $tpl.siblings('.swiper-wrapper');

            // Loops through each category inside the images array
            $.each(d, function (category, dataset) {
                var catName = category + '-category',
                    add = '',
                    markup = $tpl.html();

                // Generate the markup for the new slides
                // and replace the old images of that category
                // eith the new ones
                $.each(dataset || [], function (i, v) {
                    v.className = catName;
                    add += Mustache.render(markup, v);
                });

                $slideContainer.find('.' + catName).remove();

                $slideContainer.append(add);
            });
        });
    };

    // ########## INITIALIZATION ##########

    /**
     * Init function of the widget
     *
     * @constructor
     */
    module.init = function (done) {
        configuration.template = options.template;
        $template = $(options.template);

        $this.on('click', options.target, _clickHandler).on(jse.libs.theme.events.SLIDES_UPDATE(), _addSlides);

        $body.on(jse.libs.theme.events.BREAKPOINT(), _breakpointHandler);

        done();
    };

    // Return data to widget engine
    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
